//I'm tossing all the commander scripts into here as well as the functions that call them.
//$DF_Extraction_Speaker["Intro",$DF_Extraction_Count] = "Commander"; $DF_Extraction_Message[Intro,$DF_Extraction_Count] = ""; $DF_Extraction_Count++;

//=================================================================================================================================================================================================================================================================================

// Intro scripts
$DF_Extraction_Voice["Commander"] = 1;
$DF_Extraction_Voice["Hawk Command Delta"] = 2;
$DF_Extraction_Count = 0;

$DF_Extraction_Speaker["Intro",$DF_Extraction_Count] = "Commander"; $DF_Extraction_Message[Intro,$DF_Extraction_Count] = "Here's the situation men."; $DF_Extraction_Count++;
$DF_Extraction_Speaker["Intro",$DF_Extraction_Count] = "Commander"; $DF_Extraction_Message[Intro,$DF_Extraction_Count] = "We've been keeping you in the dark so as to prevent any possible leak of information."; $DF_Extraction_Count++;
$DF_Extraction_Speaker["Intro",$DF_Extraction_Count] = "Commander"; $DF_Extraction_Message[Intro,$DF_Extraction_Count] = "Recently an enemy insurgent had acquired some valuable information regarding our offensive plans in their country."; $DF_Extraction_Count++;
$DF_Extraction_Speaker["Intro",$DF_Extraction_Count] = "Commander"; $DF_Extraction_Message[Intro,$DF_Extraction_Count] = "This information included strike plans and locations, equipment and force statistics, but more importantly, technological outlines of some of our newest equipment."; $DF_Extraction_Count++;
$DF_Extraction_Speaker["Intro",$DF_Extraction_Count] = "Commander"; $DF_Extraction_Message[Intro,$DF_Extraction_Count] = "We're prepared to accept a loss on all but the technological outlines, which they couldn't have had an opportunity to look through yet."; $DF_Extraction_Count++;
$DF_Extraction_Speaker["Intro",$DF_Extraction_Count] = "Commander"; $DF_Extraction_Message[Intro,$DF_Extraction_Count] = "Our own intel people have indicated that the CD on which this information is held is in the complex you're about to infiltrate."; $DF_Extraction_Count++;
$DF_Extraction_Speaker["Intro",$DF_Extraction_Count] = "Commander"; $DF_Extraction_Message[Intro,$DF_Extraction_Count] = "Evidently, it was moved there for defensive reasons, before being sent back to their central command."; $DF_Extraction_Count++;
$DF_Extraction_Speaker["Intro",$DF_Extraction_Count] = "Commander"; $DF_Extraction_Message[Intro,$DF_Extraction_Count] = "As a result, last night we focused heavy air strikes on the road approaching the complex."; $DF_Extraction_Count++;
$DF_Extraction_Speaker["Intro",$DF_Extraction_Count] = "Commander"; $DF_Extraction_Message[Intro,$DF_Extraction_Count] = "This has collapsed the canyon walls, rendering it useless to the enemy, and suggests a precursor to a feigned full-scale frontal assault on the base."; $DF_Extraction_Count++;
$DF_Extraction_Speaker["Intro",$DF_Extraction_Count] = "Commander"; $DF_Extraction_Message[Intro,$DF_Extraction_Count] = "The rouse has succeeded in its primary purpose of focusing the majority of their defensive forces in the area to the head of the canyon through which the road runs."; $DF_Extraction_Count++;
$DF_Extraction_Speaker["Intro",$DF_Extraction_Count] = "Commander"; $DF_Extraction_Message[Intro,$DF_Extraction_Count] = "This has left the complex itself lightly defended, and prime for a small infiltration operation, which you will execute as team Alpha Shadow."; $DF_Extraction_Count++;
$DF_Extraction_Speaker["Intro",$DF_Extraction_Count] = "Commander"; $DF_Extraction_Message[Intro,$DF_Extraction_Count] = "Our reports show that they get routine supply drops via helicopter close to the DZ where we'll be targeting your drop."; $DF_Extraction_Count++;
$DF_Extraction_Speaker["Intro",$DF_Extraction_Count] = "Commander"; $DF_Extraction_Message[Intro,$DF_Extraction_Count] = "During this time, any personnel guarding their chopper pads will be distracted by the supply helicopter, and hopefully won't notice your decent."; $DF_Extraction_Count++;
$DF_Extraction_Speaker["Intro",$DF_Extraction_Count] = "Commander"; $DF_Extraction_Message[Intro,$DF_Extraction_Count] = "As a result, when HQ gives the clear, you will proceed to the DZ."; $DF_Extraction_Count++;
$DF_Extraction_Speaker["Intro",$DF_Extraction_Count] = "Commander"; $DF_Extraction_Message[Intro,$DF_Extraction_Count] = "Once you've regrouped, proceed to waypoint one, and continue along the top of the enemy compound."; $DF_Extraction_Count++;
$DF_Extraction_Speaker["Intro",$DF_Extraction_Count] = "Commander"; $DF_Extraction_Message[Intro,$DF_Extraction_Count] = "You'll have to neutralize some of the guards along the way, but do so *silently*."; $DF_Extraction_Count++;
$DF_Extraction_Speaker["Intro",$DF_Extraction_Count] = "Commander"; $DF_Extraction_Message[Intro,$DF_Extraction_Count] = "There is an access hatch to the roof that originates in the main command room. "; $DF_Extraction_Count++;
$DF_Extraction_Speaker["Intro",$DF_Extraction_Count] = "Commander"; $DF_Extraction_Message[Intro,$DF_Extraction_Count] = "You will proceed down this hatch to where the main command room is located. "; $DF_Extraction_Count++;
$DF_Extraction_Speaker["Intro",$DF_Extraction_Count] = "Commander"; $DF_Extraction_Message[Intro,$DF_Extraction_Count] = "The CD should be in this area. Grab it, and exit the base through the front door."; $DF_Extraction_Count++;
$DF_Extraction_Speaker["Intro",$DF_Extraction_Count] = "Commander"; $DF_Extraction_Message[Intro,$DF_Extraction_Count] = "You will probably meet some resistance near the entrance of the compound, but it will be significantly less then the surrounding hills."; $DF_Extraction_Count++;
$DF_Extraction_Speaker["Intro",$DF_Extraction_Count] = "Commander"; $DF_Extraction_Message[Intro,$DF_Extraction_Count] = "In addition, satellite imagery shows that they have a stolen Abrams battle tank sitting out front of the compound."; $DF_Extraction_Count++;
$DF_Extraction_Speaker["Intro",$DF_Extraction_Count] = "Commander"; $DF_Extraction_Message[Intro,$DF_Extraction_Count] = "Apprehend it, and use it to clear the way to the extraction point. Once there, radio HQ for a Blackhawk to extract the team."; $DF_Extraction_Count++;
$DF_Extraction_Speaker["Intro",$DF_Extraction_Count] = "Commander"; $DF_Extraction_Message[Intro,$DF_Extraction_Count] = "With the CD safe, we'll be free to nape the whole complex and surrounding area with impunity."; $DF_Extraction_Count++;
$DF_Extraction_Speaker["Intro",$DF_Extraction_Count] = "Commander"; $DF_Extraction_Message[Intro,$DF_Extraction_Count] = "Keep your radios on in case I need to provide updates, and good luck!"; $DF_Extraction_Count++;
$DF_Extraction_Count["Intro"] = $DF_Extraction_Count;


$DF_Extraction_Count = 0;
$DF_Extraction_Speaker["Drop",$DF_Extraction_Count] = "Hawk Command Delta"; $DF_Extraction_Message[Drop,$DF_Extraction_Count] = "Alpha Shadow, the enemy is distracted; proceed with your drop."; $DF_Extraction_Count++;
$DF_Extraction_Speaker["Drop",$DF_Extraction_Count] = "Commander"; $DF_Extraction_Message[Drop,$DF_Extraction_Count] = "You heard the man. Lock and load boys; good luck."; $DF_Extraction_Count++;
$DF_Extraction_Count["Drop"] = $DF_Extraction_Count;


// Function to run intro scripts
function DF_Extraction_RunIntroScripts()
{
	// Intro stuff.
	%messages = "Intro";
	%delay = 20;
	
	%team = 0;

	if(!$DF_Extraction_Skip_Intro)
	{

		for(%x = 0;%x < $DF_Extraction_Count[%messages];%x++)
		{
			%message = $DF_Extraction_Speaker[%messages,%x] @ ": "@$DF_Extraction_Message[%messages,%x];
		
			Schedule("teamMessages(\""@$MsgTypeTeamChat@"\", \""@%team@"\",\"" @%message@"\");",%delay);
			%delay = %delay + String::length(%message)/13;
		}
	}

	// Drop stuff.
	%messages = "Drop";
	%delay = %delay + 30;// 30 seconds after the commander finishes.
	schedule("OpenAirplaneDoor("@nametoid("MissionGroup\\AirCraft\\AirplaneDoor\\Door\\Door")@", 0);", %delay+5);
	
	schedule("DropSpecSupply(\"452.93 -328.682 585\");", %delay + 20);
	// Call in the chopper.
	schedule("AirStrike::BlackhawkThree();",%delay - 55);
	//schedule("AirStrike::BlackhawkThree();",%delay - 55);
	doMineDrop("225 14 26", 1, 10, 30);
	doMineDrop("250 45 35", 3, 4, 0);
	%team = 0;
	schedule("SetupAAILoad(MainAI);", %delay+5);	
	schedule("StartBorderChecking();", %delay+5);
	for(%x = 0;%x < $DF_Extraction_Count[%messages];%x++)
	{
		%message = $DF_Extraction_Speaker[%messages,%x] @ ": "@$DF_Extraction_Message[%messages,%x];
		Schedule("teamMessages(\""@$MsgTypeTeamChat@"\", \""@%team@"\",\"" @%message@"\");",%delay);
		%delay = %delay + String::length(%message)/13;
	}	
	
}
function dominedrop(%pos, %min, %max, %scale)
{
for(%x = %min; %x < %max; %x++)
{
	
		%obj = newObject("","Mine",AntiarmorMine);
		addToSet("MissionCleanup", %obj);
		GameBase::setPosition(%obj, %pos);
		%dir = vector::add(vector::getfromrot(0@" 0 "@$SwingRot[%x], %scale), "0 0 10");
		echo(%dir);
		item::setvelocity(%obj, %dir);

}

}

function OpenAirplaneDoor(%this, %close)
{
	$AirPlaneDoorPos = gamebase::getposition(%this);
	
	if(!%close) 
	{
		playSound("SoundWindGustAirplaneDoor",$AirPlaneDoorPos);
		%this.status = "open";
		%this.closetime = getsimtime()+3;
		%this.delay = getsimtime()+3;
		Moveable::moveToWaypoint(%this,0);				
	}
	else 
	{ 
	Moveable::moveToWaypoint(%this,1);				
	}
}
//=================================================================================================================================================================================================================================================================================


// Information for alarm locations.
$AlarmLightCount=0;
$AlarmLightPos[$AlarmLightCount] = "466 28.65 30";
$AlarmLightRange[$AlarmLightCount] = "5";
$AlarmLightCount++;

$AlarmLightPos[$AlarmLightCount] = "465.57 35.58 30";
$AlarmLightRange[$AlarmLightCount] = "5";
$AlarmLightCount++;

$AlarmLightPos[$AlarmLightCount] = "473.77 37.5 33";
$AlarmLightRange[$AlarmLightCount] = "10";
$AlarmLightCount++;

$AlarmLightPos[$AlarmLightCount] = "474.5 26 33";
$AlarmLightRange[$AlarmLightCount] = "10";
$AlarmLightCount++;

$AlarmLightPos[$AlarmLightCount] = "475.7 13.8 33";
$AlarmLightRange[$AlarmLightCount] = "15";
$AlarmLightCount++;

$AlarmLightPos[$AlarmLightCount] = "462.627 24.7351 38";
$AlarmLightRange[$AlarmLightCount] = "7";
$AlarmLightCount++;

$AlarmLightPos[$AlarmLightCount] = "457.903 24.3299 38";
$AlarmLightRange[$AlarmLightCount] = "7";
$AlarmLightCount++;

$AlarmLightPos[$AlarmLightCount] = "452.753 24.0597 38.0729";
$AlarmLightRange[$AlarmLightCount] = "7";
$AlarmLightCount++;

$AlarmLightPos[$AlarmLightCount] = "452.753 24.0597 38.0729";
$AlarmLightRange[$AlarmLightCount] = "7";
$AlarmLightCount++;

$AlarmLightPos[$AlarmLightCount] = "460.502 31.0274 33.5758";
$AlarmLightRange[$AlarmLightCount] = "20";
$AlarmLightCount++;

$AlarmLightPos[$AlarmLightCount] = "478 8.91753 14.1";
$AlarmLightRange[$AlarmLightCount] = "8";
$AlarmLightCount++;

$AlarmLightPos[$AlarmLightCount] = "474 8.66085 14.1";
$AlarmLightRange[$AlarmLightCount] = "8";
$AlarmLightCount++;

$AlarmLightPos[$AlarmLightCount] = "475 17.8 14.8";
$AlarmLightRange[$AlarmLightCount] = "8";
$AlarmLightCount++;

$AlarmLightPos[$AlarmLightCount] = "468.4 14.32 19";
$AlarmLightRange[$AlarmLightCount] = "8";
$AlarmLightCount++;

// Spawn the alarms
function DF_Extraction_SpawnAlarm()
{
	$AlarmLightGroup = newObject("Lights", SimGroup);
	addtoset("MissionCleanup", $AlarmLightGroup);
	for(%x = 0; %x<$AlarmLightCount; %x++)
	{
	%light = newObject("Light","SimLight", Point, $AlarmLightRange[%x], 1, 0, 0, getword($AlarmLightPos[%x], 0),  getword($AlarmLightPos[%x], 1),  getword($AlarmLightPos[%x], 2));
	addtoset($AlarmLightGroup, %light);
	
	}
	schedule("deleteobject("@$AlarmLightGroup@");", 120);
	//messageall(1, "The alarm system has been triggered!~wLeftMissionArea.wav");
	for(%i = 0; %i < 12; %i++)
	{
	
	//schedule("messageall(0, \"~waccess_denied.wav\");", %i);
		for(%x = 0; %x<$AlarmLightCount; %x++)
		{
			schedule("playSound(SoundAlarmClang2,\""@$AlarmLightPos[%x]@"\");",1.8*%i);
			schedule("playSound(SoundAlarmClang1,\""@$AlarmLightPos[%x]@"\");",1.8*%i+0.35);
		}
	}
}

// Alarm Scripts
$DF_Extraction_Count = 0;
$DF_Extraction_Speaker["Alarm-1",$DF_Extraction_Count] = "Commander"; $DF_Extraction_Message["Alarm-1",$DF_Extraction_Count] = "Alpha Shadow; hold your position, and wait for further instructions.~wmale5.wwait1.wav"; $DF_Extraction_Count++;
$DF_Extraction_Speaker["Alarm-1",$DF_Extraction_Count] = "Commander"; $DF_Extraction_Message["Alarm-1",$DF_Extraction_Count] = "I've requested a live feed of the area from HQ and will reevaluate the situation as quickly as possible."; $DF_Extraction_Count++;
$DF_Extraction_Speaker["Alarm-1",$DF_Extraction_Count] = "Commander"; $DF_Extraction_Message["Alarm-1",$DF_Extraction_Count] = "Do not-I repeat-do not move from your present location until further instructions.~wmale5.wwaitsig.wav"; $DF_Extraction_Count++;
$DF_Extraction_Count["Alarm-1"] = $DF_Extraction_Count;

$DF_Extraction_Count = 0;
$DF_Extraction_Speaker["Alarm-2",$DF_Extraction_Count] = "Commander"; $DF_Extraction_Message["Alarm-2",$DF_Extraction_Count] = "Alpha Shadow; were not detecting any movement from the enemy outside the compound."; $DF_Extraction_Count++;
$DF_Extraction_Speaker["Alarm-2",$DF_Extraction_Count] = "Commander"; $DF_Extraction_Message["Alarm-2",$DF_Extraction_Count] = "It appears youve simply managed to empty the base. The bad news is that theyre all in your way."; $DF_Extraction_Count++;
$DF_Extraction_Speaker["Alarm-2",$DF_Extraction_Count] = "Commander"; $DF_Extraction_Message["Alarm-2",$DF_Extraction_Count] = "Youll have to fight your way out of the compound Im afraid."; $DF_Extraction_Count++;
$DF_Extraction_Speaker["Alarm-2",$DF_Extraction_Count] = "Commander"; $DF_Extraction_Message["Alarm-2",$DF_Extraction_Count] = "The good news is that the stolen Abrams we saw pre-drop is still in the courtyard, and should be sufficient to spearhead your way out of the enemys fortifications."; $DF_Extraction_Count++;
$DF_Extraction_Speaker["Alarm-2",$DF_Extraction_Count] = "Commander"; $DF_Extraction_Message["Alarm-2",$DF_Extraction_Count] = "Exit through the courtyard of the enemy compound, and proceed west to the extraction point. When you arrive, radio for pickup. Commander out.~wmale5.wproceed.wav"; $DF_Extraction_Count++;
$DF_Extraction_Count["Alarm-2"] = $DF_Extraction_Count;

// Function to run Alarm scripts. Requires a client input.
function DF_Extraction_RunAlarmScripts(%cl)
{
	DF_Extraction_SpawnAlarm();
	%team = 0;
	%message = client::Getname(%cl) @ ": Commander, we have found the CD but appear to have triggered some sort of alarm. Please advise.";
	teamMessages($MsgTypeTeamChat, %team, %message);
		
	%messages = "Alarm-1";
	%delay = 5;
	%team = 0;
	for(%x = 0;%x < $DF_Extraction_Count[%messages];%x++)
	{
		%message = $DF_Extraction_Speaker[%messages,%x] @ ": "@$DF_Extraction_Message[%messages,%x];
	
		Schedule("teamMessages(\""@$MsgTypeTeamChat@"\", \""@%team@"\",\"" @%message@"\");",%delay);
		%delay = %delay + String::length(%message)/13;
	}

	%messages = "Alarm-2";
	%delay = %delay + 10;
	%team = 0;
	for(%x = 0;%x < $DF_Extraction_Count[%messages];%x++)
	{
		%message = $DF_Extraction_Speaker[%messages,%x] @ ": "@$DF_Extraction_Message[%messages,%x];
	
		Schedule("teamMessages(\""@$MsgTypeTeamChat@"\", \""@%team@"\",\"" @%message@"\");",%delay);
		%delay = %delay + String::length(%message)/13;
	}
}

//=================================================================================================================================================================================================================================================================================

// Exit Scripts
$DF_Extraction_Count = 0;
$DF_Extraction_Speaker["Exit",$DF_Extraction_Count] = "Commander"; $DF_Extraction_Message[Exit,$DF_Extraction_Count] = "Alpha Shadow; were picking up some sudden movement west of your position."; $DF_Extraction_Count++;
$DF_Extraction_Speaker["Exit",$DF_Extraction_Count] = "Commander"; $DF_Extraction_Message[Exit,$DF_Extraction_Count] = "It appears that that alarm might have caused more of an alert then we thought."; $DF_Extraction_Count++;
$DF_Extraction_Speaker["Exit",$DF_Extraction_Count] = "Commander"; $DF_Extraction_Message[Exit,$DF_Extraction_Count] = "Thermal scans have picked up only some light enemy activity already in position, but more appear to almost be materializing out of the surrounding hills."; $DF_Extraction_Count++;
$DF_Extraction_Speaker["Exit",$DF_Extraction_Count] = "Commander"; $DF_Extraction_Message[Exit,$DF_Extraction_Count] = "So far their main force is still clustered in the area towards the head of the canyon, and hasnt moved."; $DF_Extraction_Count++;
$DF_Extraction_Speaker["Exit",$DF_Extraction_Count] = "Commander"; $DF_Extraction_Message[Exit,$DF_Extraction_Count] = "But keep a sharp eye out; they might have more resources focused in on this area then we thought."; $DF_Extraction_Count++;
$DF_Extraction_Speaker["Exit",$DF_Extraction_Count] = "Commander"; $DF_Extraction_Message[Exit,$DF_Extraction_Count] = "Commander out."; $DF_Extraction_Count++;
$DF_Extraction_Count["Exit"] = $DF_Extraction_Count;

// Function to run exit scripts
function DF_Extraction_RunExitScripts()
{
	%team = 0;
	
	%messages = "Exit";
	%delay = 5;
	%team = 0;
	for(%x = 0;%x < $DF_Extraction_Count[%messages];%x++)
	{
		%message = $DF_Extraction_Speaker[%messages,%x] @ ": "@$DF_Extraction_Message[%messages,%x];
	
		Schedule("teamMessages(\""@$MsgTypeTeamChat@"\", \""@%team@"\",\"" @%message@"\");",%delay);
		%delay = %delay + String::length(%message)/13;
	}
}

//=================================================================================================================================================================================================================================================================================

// ExtractOne scripts
$DF_Extraction_Count = 0;
$DF_Extraction_Speaker["Extract1-1",$DF_Extraction_Count] = "Commander"; $DF_Extraction_Message["Extract1-1",$DF_Extraction_Count] = "I hear you loud and clear Alpha Shadow."; $DF_Extraction_Count++;
$DF_Extraction_Speaker["Extract1-1",$DF_Extraction_Count] = "Commander"; $DF_Extraction_Message["Extract1-1",$DF_Extraction_Count] = "Good job on the pickup. Proceed and wait at the Extraction Point."; $DF_Extraction_Count++;
$DF_Extraction_Speaker["Extract1-1",$DF_Extraction_Count] = "Commander"; $DF_Extraction_Message["Extract1-1",$DF_Extraction_Count] = "I've already send a request for the Blackhawk and it should be on it's way."; $DF_Extraction_Count++;
$DF_Extraction_Speaker["Extract1-1",$DF_Extraction_Count] = "Commander"; $DF_Extraction_Message["Extract1-1",$DF_Extraction_Count] = "Keep the area clear until it arrives."; $DF_Extraction_Count++;
$DF_Extraction_Count["Extract1-1"] = $DF_Extraction_Count;

$DF_Extraction_Count = 0;
$DF_Extraction_Speaker["Extract1-2",$DF_Extraction_Count] = "Blawkhawk Pilot"; $DF_Extraction_Message["Extract1-2",$DF_Extraction_Count] = "Alpha Shadow, this is Hawk 03."; $DF_Extraction_Count++;
$DF_Extraction_Speaker["Extract1-2",$DF_Extraction_Count] = "Blawkhawk Pilot"; $DF_Extraction_Message["Extract1-2",$DF_Extraction_Count] = "I have your position and am on my way."; $DF_Extraction_Count++;
$DF_Extraction_Speaker["Extract1-2",$DF_Extraction_Count] = "Blawkhawk Pilot"; $DF_Extraction_Message["Extract1-2",$DF_Extraction_Count] = "Hang in there."; $DF_Extraction_Count++;
$DF_Extraction_Count["Extract1-2"] = $DF_Extraction_Count;

$DF_Extraction_Count = 0;
$DF_Extraction_Speaker["Extract1-3",$DF_Extraction_Count] = "Blawkhawk Pilot"; $DF_Extraction_Message["Extract1-3",$DF_Extraction_Count] = "Mayday! Mayday! I've got enemy locks!~wmale4.whelp.wav"; $DF_Extraction_Count++;
$DF_Extraction_Speaker["Extract1-3",$DF_Extraction_Count] = "Blawkhawk Pilot"; $DF_Extraction_Message["Extract1-3",$DF_Extraction_Count] = "I can't shake them!"; $DF_Extraction_Count++;
$DF_Extraction_Count["Extract1-3"] = $DF_Extraction_Count;

$DF_Extraction_Count = 0;
$DF_Extraction_Speaker["Extract1-4",$DF_Extraction_Count] = "Commander"; $DF_Extraction_Message["Extract1-4",$DF_Extraction_Count] = "We heard it Alpha Shadow."; $DF_Extraction_Count++;
$DF_Extraction_Speaker["Extract1-4",$DF_Extraction_Count] = "Commander"; $DF_Extraction_Message["Extract1-4",$DF_Extraction_Count] = "That area is too hot to send another chopper into."; $DF_Extraction_Count++;
$DF_Extraction_Speaker["Extract1-4",$DF_Extraction_Count] = "Commander"; $DF_Extraction_Message["Extract1-4",$DF_Extraction_Count] = "You're going to have to hump your way to the road block about 800 meters west of your position."; $DF_Extraction_Count++;
$DF_Extraction_Speaker["Extract1-4",$DF_Extraction_Count] = "Commander"; $DF_Extraction_Message["Extract1-4",$DF_Extraction_Count] = "It appears that's the furthest extent of the enemy defenses, and the only safe place for an extraction."; $DF_Extraction_Count++;
$DF_Extraction_Speaker["Extract1-4",$DF_Extraction_Count] = "Commander"; $DF_Extraction_Message["Extract1-4",$DF_Extraction_Count] = "It's going to be messy, but I'll try to find you some backup."; $DF_Extraction_Count++;
$DF_Extraction_Speaker["Extract1-4",$DF_Extraction_Count] = "Commander"; $DF_Extraction_Message["Extract1-4",$DF_Extraction_Count] = "Get moving, and keep your heads down. Commander out.~wmale5.wgooff.wav"; $DF_Extraction_Count++;
$DF_Extraction_Count["Extract1-4"] = $DF_Extraction_Count;

// Function to run ExtractOne scripts. Requires a client input.
function DF_Extraction_RunExtractOneScripts(%cl)
{
	AirStrike::BlackhawkOne();
	
	%team = 0;
	%message = client::Getname(%cl) @ ": Commander, we have the CD and are approaching the Extraction point.";
	teamMessages($MsgTypeTeamChat, %team, %message);
		
	// Spawn extraction blackhawk
	// Intro stuff.
	%messages = "Extract1-1";
	%delay = 5;
	%team = 0;
	for(%x = 0;%x < $DF_Extraction_Count[%messages];%x++)
	{
		%message = $DF_Extraction_Speaker[%messages,%x] @ ": "@$DF_Extraction_Message[%messages,%x];
	
		Schedule("teamMessages(\""@$MsgTypeTeamChat@"\", \""@%team@"\",\"" @%message@"\");",%delay);
		%delay = %delay + String::length(%message)/13;
	}

	%messages = "Extract1-2";
	%delay = %delay + 25;
	%team = 0;
	for(%x = 0;%x < $DF_Extraction_Count[%messages];%x++)
	{
		%message = $DF_Extraction_Speaker[%messages,%x] @ ": "@$DF_Extraction_Message[%messages,%x];
	
		Schedule("teamMessages(\""@$MsgTypeTeamChat@"\", \""@%team@"\",\"" @%message@"\");",%delay);
		%delay = %delay + String::length(%message)/13;
	}

	%messages = "Extract1-3";
	%delay = %delay + 25;
	%team = 0;
	for(%x = 0;%x < $DF_Extraction_Count[%messages];%x++)
	{
		%message = $DF_Extraction_Speaker[%messages,%x] @ ": "@$DF_Extraction_Message[%messages,%x];
	
		Schedule("teamMessages(\""@$MsgTypeTeamChat@"\", \""@%team@"\",\"" @%message@"\");",%delay);
		%delay = %delay + String::length(%message)/13;
	}

	%delay = %delay + 13;
	%message = client::Getname(%cl) @ ": Commander...";
	Schedule("teamMessages(\""@$MsgTypeTeamChat@"\", \""@%team@"\",\"" @%message@"\");",%delay);


	%messages = "Extract1-4";
	%delay = %delay + 2;
	%team = 0;
	for(%x = 0;%x < $DF_Extraction_Count[%messages];%x++)
	{
		%message = $DF_Extraction_Speaker[%messages,%x] @ ": "@$DF_Extraction_Message[%messages,%x];
	
		Schedule("teamMessages(\""@$MsgTypeTeamChat@"\", \""@%team@"\",\"" @%message@"\");",%delay);
		%delay = %delay + String::length(%message)/13;
	}

}

//=================================================================================================================================================================================================================================================================================

$DF_Extraction_Count = 0;
$DF_Extraction_Speaker["PreBridge",$DF_Extraction_Count] = "Commander"; $DF_Extraction_Message[PreBridge,$DF_Extraction_Count] = "Alpha Shadow; Ive confirmed with Hawk Command Delta."; $DF_Extraction_Count++;
$DF_Extraction_Speaker["PreBridge",$DF_Extraction_Count] = "Commander"; $DF_Extraction_Message[PreBridge,$DF_Extraction_Count] = "It appears that the closest place from which we can safely extract you is still just east of the roadblock at the end of the canyon."; $DF_Extraction_Count++;
$DF_Extraction_Speaker["PreBridge",$DF_Extraction_Count] = "Commander"; $DF_Extraction_Message[PreBridge,$DF_Extraction_Count] = "The heavy bombing of the area used to knock out the bridge successfully eliminated the AA capabilities that they had positioned there."; $DF_Extraction_Count++;
$DF_Extraction_Speaker["PreBridge",$DF_Extraction_Count] = "Commander"; $DF_Extraction_Message[PreBridge,$DF_Extraction_Count] = "Continue to the roadblock, but watch out for ambushes. We keep catching faint signals on the thermal scans, but they disappear almost immediately."; $DF_Extraction_Count++;
$DF_Extraction_Speaker["PreBridge",$DF_Extraction_Count] = "Commander"; $DF_Extraction_Message[PreBridge,$DF_Extraction_Count] = "The bridge up ahead is still in working condition, and almost undoubtedly in the enemys control."; $DF_Extraction_Count++;
$DF_Extraction_Speaker["PreBridge",$DF_Extraction_Count] = "Commander"; $DF_Extraction_Message[PreBridge,$DF_Extraction_Count] = "Experience tells me its a perfect place for such an ambush."; $DF_Extraction_Count++;
$DF_Extraction_Speaker["PreBridge",$DF_Extraction_Count] = "Commander"; $DF_Extraction_Message[PreBridge,$DF_Extraction_Count] = "The techs at HQ have also determined that thats where the AA fire came from that took down our Blackhawk, so keep an eye on that bridge."; $DF_Extraction_Count++;
$DF_Extraction_Speaker["PreBridge",$DF_Extraction_Count] = "Commander"; $DF_Extraction_Message[PreBridge,$DF_Extraction_Count] = "Commander out."; $DF_Extraction_Count++;
$DF_Extraction_Count["PreBridge"] = $DF_Extraction_Count;

// Function to run PreBridge scripts.
function DF_Extraction_RunPreBridgeScripts()
{
	%team = 0;
	
	%messages = "PreBridge";
	%delay = 3;
	%team = 0;
	for(%x = 0;%x < $DF_Extraction_Count[%messages];%x++)
	{
		%message = $DF_Extraction_Speaker[%messages,%x] @ ": "@$DF_Extraction_Message[%messages,%x];
	
		Schedule("teamMessages(\""@$MsgTypeTeamChat@"\", \""@%team@"\",\"" @%message@"\");",%delay);
		%delay = %delay + String::length(%message)/13;
	}
}

//=================================================================================================================================================================================================================================================================================

$DF_Extraction_Count = 0;
$DF_Extraction_Speaker["AmbushBridge-1",$DF_Extraction_Count] = "Commander"; $DF_Extraction_Message["AmbushBridge-1",$DF_Extraction_Count] = "Alpha Shadow, weve got major activity on the thermal scans."; $DF_Extraction_Count++;
$DF_Extraction_Speaker["AmbushBridge-1",$DF_Extraction_Count] = "Commander"; $DF_Extraction_Message["AmbushBridge-1",$DF_Extraction_Count] = "Youve got an ambush on your hands! Get under cover immediately!~wmale5.wtakcovr.wav"; $DF_Extraction_Count++;
$DF_Extraction_Count["AmbushBridge-1"] = $DF_Extraction_Count;

$DF_Extraction_Count = 0;
$DF_Extraction_Speaker["AmbushBridge-2",$DF_Extraction_Count] = "Commander"; $DF_Extraction_Message["AmbushBridge-2",$DF_Extraction_Count] = "This is not looking good Alpha Shadow. Ive got lots of ground activity on the scanners, although were unable to pinpoint most of them."; $DF_Extraction_Count++;
$DF_Extraction_Speaker["AmbushBridge-2",$DF_Extraction_Count] = "Commander"; $DF_Extraction_Message["AmbushBridge-2",$DF_Extraction_Count] = "We have also picked up enemy air activity on the radar heading straight for your position."; $DF_Extraction_Count++;
$DF_Extraction_Speaker["AmbushBridge-2",$DF_Extraction_Count] = "Commander"; $DF_Extraction_Message["AmbushBridge-2",$DF_Extraction_Count] = "Weve dispatched an interceptor to cover your retreat, but we dont know if itll arrive in time."; $DF_Extraction_Count++;
$DF_Extraction_Speaker["AmbushBridge-2",$DF_Extraction_Count] = "Commander"; $DF_Extraction_Message["AmbushBridge-2",$DF_Extraction_Count] = "Theres also a large enemy force of ground troops that have just exited the compound, and are coming up on your rear fast."; $DF_Extraction_Count++;
$DF_Extraction_Speaker["AmbushBridge-2",$DF_Extraction_Count] = "Commander"; $DF_Extraction_Message["AmbushBridge-2",$DF_Extraction_Count] = "Youll have to keep ahead of them--there are too many for you to handle."; $DF_Extraction_Count++;
$DF_Extraction_Speaker["AmbushBridge-2",$DF_Extraction_Count] = "Commander"; $DF_Extraction_Message["AmbushBridge-2",$DF_Extraction_Count] = "Keep moving Alpha Shadow. Commander out."; $DF_Extraction_Count++;
$DF_Extraction_Count["AmbushBridge-2"] = $DF_Extraction_Count;

// Function to run ExtractOne scripts.
function DF_Extraction_RunAmbushBridgeScripts()
{
	%team = 0;

	// Spawn bomber
	AirStrike::NapalmStrike();
	
	%messages = "AmbushBridge-1";
	%delay = 3;
	%team = 0;
	for(%x = 0;%x < $DF_Extraction_Count[%messages];%x++)
	{
		%message = $DF_Extraction_Speaker[%messages,%x] @ ": "@$DF_Extraction_Message[%messages,%x];
	
		Schedule("teamMessages(\""@$MsgTypeTeamChat@"\", \""@%team@"\",\"" @%message@"\");",%delay);
		%delay = %delay + String::length(%message)/13;
	}

	%messages = "AmbushBridge-2";
	%delay = %delay + 10;
	%team = 0;
	for(%x = 0;%x < $DF_Extraction_Count[%messages];%x++)
	{
		%message = $DF_Extraction_Speaker[%messages,%x] @ ": "@$DF_Extraction_Message[%messages,%x];
	
		Schedule("teamMessages(\""@$MsgTypeTeamChat@"\", \""@%team@"\",\"" @%message@"\");",%delay);
		%delay = %delay + String::length(%message)/13;
	}
}

//=================================================================================================================================================================================================================================================================================

$DF_Extraction_Count = 0;
$DF_Extraction_Speaker[PostBridge,$DF_Extraction_Count] = "Commander"; $DF_Extraction_Message[PostBridge,$DF_Extraction_Count] = "Alpha Shadow; weve got continuous scattered signals from the hills and it appears theyre dispatching groups from the roadblock to intercept you."; $DF_Extraction_Count++;
$DF_Extraction_Speaker[PostBridge,$DF_Extraction_Count] = "Commander"; $DF_Extraction_Message[PostBridge,$DF_Extraction_Count] = "Ive got HQs techs on trying to clean up the signals so we can get a better idea of their movements."; $DF_Extraction_Count++;
$DF_Extraction_Speaker[PostBridge,$DF_Extraction_Count] = "Commander"; $DF_Extraction_Message[PostBridge,$DF_Extraction_Count] = "The enemy seems to be able to hide themselves from detection until their time of attack."; $DF_Extraction_Count++;
$DF_Extraction_Speaker[PostBridge,$DF_Extraction_Count] = "Commander"; $DF_Extraction_Message[PostBridge,$DF_Extraction_Count] = "For now well have to rely on your abilities to stop them, but Ill keep you posted on our progress. Commander Out."; $DF_Extraction_Count++;
$DF_Extraction_Count[PostBridge] = $DF_Extraction_Count;

// Function to run PostBridge scripts.
function DF_Extraction_RunPostBridgeScripts()
{
	%team = 0;
	
	%messages = PostBridge;
	%delay = 3;
	%team = 0;
	for(%x = 0;%x < $DF_Extraction_Count[%messages];%x++)
	{
		%message = $DF_Extraction_Speaker[%messages,%x] @ ": "@$DF_Extraction_Message[%messages,%x];
	
		Schedule("teamMessages(\""@$MsgTypeTeamChat@"\", \""@%team@"\",\"" @%message@"\");",%delay);
		%delay = %delay + String::length(%message)/13;
	}
}
//=================================================================================================================================================================================================================================================================================

$DF_Extraction_Count = 0;
$DF_Extraction_Speaker[PostBuilding,$DF_Extraction_Count] = "Commander"; $DF_Extraction_Message[PostBuilding,$DF_Extraction_Count] = "Alpha Shadow; Good news!"; $DF_Extraction_Count++;
$DF_Extraction_Speaker[PostBuilding,$DF_Extraction_Count] = "Commander"; $DF_Extraction_Message[PostBuilding,$DF_Extraction_Count] = "Although the techs werent able to clean up the signals much, they were able to devise a way to predict the direction of travel of the enemy forces."; $DF_Extraction_Count++;
$DF_Extraction_Speaker[PostBuilding,$DF_Extraction_Count] = "Commander"; $DF_Extraction_Message[PostBuilding,$DF_Extraction_Count] = "It appears that they definitely know about you, and are converging on your location."; $DF_Extraction_Count++;
$DF_Extraction_Speaker[PostBuilding,$DF_Extraction_Count] = "Commander"; $DF_Extraction_Message[PostBuilding,$DF_Extraction_Count] = "Theres also a contingent heading in on the debris wall blocking the canyon to your west."; $DF_Extraction_Count++;
$DF_Extraction_Speaker[PostBuilding,$DF_Extraction_Count] = "Commander"; $DF_Extraction_Message[PostBuilding,$DF_Extraction_Count] = "No doubt theyre planning on attempting to ambush you there again, so be prepared to meet heavy resistance.~wmale5.wgodef.wav"; $DF_Extraction_Count++;
$DF_Extraction_Speaker[PostBuilding,$DF_Extraction_Count] = "Commander"; $DF_Extraction_Message[PostBuilding,$DF_Extraction_Count] = "Commander out."; $DF_Extraction_Count++;
$DF_Extraction_Count[PostBuilding] = $DF_Extraction_Count;

// Function to run PostBuilding scripts.
function DF_Extraction_RunPostBuildingScripts()
{
	%team = 0;
	
	%messages = PostBuilding;
	%delay = 3;
	%team = 0;
	for(%x = 0;%x < $DF_Extraction_Count[%messages];%x++)
	{
		%message = $DF_Extraction_Speaker[%messages,%x] @ ": "@$DF_Extraction_Message[%messages,%x];
	
		Schedule("teamMessages(\""@$MsgTypeTeamChat@"\", \""@%team@"\",\"" @%message@"\");",%delay);
		%delay = %delay + String::length(%message)/13;
	}
}

//=================================================================================================================================================================================================================================================================================

$DF_Extraction_Count = 0;
//$DF_Extraction_Speaker[Wallbreak,$DF_Extraction_Count] = "Commander"; $DF_Extraction_Message[Wallbreak,$DF_Extraction_Count] = ""; $DF_Extraction_Count++;
$DF_Extraction_Count[Wallbreak] = $DF_Extraction_Count;

// Function to run Wallbreak scripts.
function DF_Extraction_RunWallbreakScripts()
{
	%team = 0;
	
	%messages = Wallbreak;
	%delay = 3;
	%team = 0;
	for(%x = 0;%x < $DF_Extraction_Count[%messages];%x++)
	{
		%message = $DF_Extraction_Speaker[%messages,%x] @ ": "@$DF_Extraction_Message[%messages,%x];
	
		Schedule("teamMessages(\""@$MsgTypeTeamChat@"\", \""@%team@"\",\"" @%message@"\");",%delay);
		%delay = %delay + String::length(%message)/13;
	}
}

//=================================================================================================================================================================================================================================================================================

$DF_Extraction_Count = 0;
//$DF_Extraction_Speaker[Embankments,$DF_Extraction_Count] = "Commander"; $DF_Extraction_Message[Embankments,$DF_Extraction_Count] = ""; $DF_Extraction_Count++;
$DF_Extraction_Count[Embankments] = $DF_Extraction_Count;

// Function to run Wallbreak scripts.
function DF_Extraction_RunEmbankmentsScripts()
{
	%team = 0;
	
	%messages = Embankments;
	%delay = 3;
	%team = 0;
	for(%x = 0;%x < $DF_Extraction_Count[%messages];%x++)
	{
		%message = $DF_Extraction_Speaker[%messages,%x] @ ": "@$DF_Extraction_Message[%messages,%x];
	
		Schedule("teamMessages(\""@$MsgTypeTeamChat@"\", \""@%team@"\",\"" @%message@"\");",%delay);
		%delay = %delay + String::length(%message)/13;
	}
}

//=================================================================================================================================================================================================================================================================================

$DF_Extraction_Count = 0;
$DF_Extraction_Speaker[PreRoadBlock,$DF_Extraction_Count] = "Commander"; $DF_Extraction_Message[PreRoadBlock,$DF_Extraction_Count] = "Alpha Shadow, youre almost home."; $DF_Extraction_Count++;
$DF_Extraction_Speaker[PreRoadBlock,$DF_Extraction_Count] = "Commander"; $DF_Extraction_Message[PreRoadBlock,$DF_Extraction_Count] = "Im sending for the Blackhawk now and it should be there in a matter of minutes."; $DF_Extraction_Count++;
$DF_Extraction_Speaker[PreRoadBlock,$DF_Extraction_Count] = "Commander"; $DF_Extraction_Message[PreRoadBlock,$DF_Extraction_Count] = "Youll have to get to the road block to hold your position in the mean time, and stay sharp."; $DF_Extraction_Count++;
$DF_Extraction_Speaker[PreRoadBlock,$DF_Extraction_Count] = "Commander"; $DF_Extraction_Message[PreRoadBlock,$DF_Extraction_Count] = "Youve stirred up a hell of a bees nest, and youre right in the middle of it. "; $DF_Extraction_Count++;
$DF_Extraction_Speaker[PreRoadBlock,$DF_Extraction_Count] = "Commander"; $DF_Extraction_Message[PreRoadBlock,$DF_Extraction_Count] = "There are signals converging on your position from all directions."; $DF_Extraction_Count++;
$DF_Extraction_Speaker[PreRoadBlock,$DF_Extraction_Count] = "Commander"; $DF_Extraction_Message[PreRoadBlock,$DF_Extraction_Count] = "Keep that landing zone clear for the extraction!"; $DF_Extraction_Count++;
$DF_Extraction_Count[PreRoadBlock] = $DF_Extraction_Count;

// Function to run PreRoadBlock scripts.
function DF_Extraction_RunPreRoadBlockScripts()
{
	%team = 0;
	AirStrike::AirCombat();
	%messages = PreRoadBlock;
	%delay = 3;
	%team = 0;
	for(%x = 0;%x < $DF_Extraction_Count[%messages];%x++)
	{
		%message = $DF_Extraction_Speaker[%messages,%x] @ ": "@$DF_Extraction_Message[%messages,%x];
	
		Schedule("teamMessages(\""@$MsgTypeTeamChat@"\", \""@%team@"\",\"" @%message@"\");",%delay);
		%delay = %delay + String::length(%message)/13;
	}
}

//=================================================================================================================================================================================================================================================================================


$SSDropCount = -1;



$SSDropItem[$SSDropCount++] = "AmmoPackSmall 6";
$SSDropItem[$SSDropCount++] = "AmmoPackHeavy 6";
$SSDropItem[$SSDropCount++] = "AmmoPackExp 6";
$SSDropItem[$SSDropCount++] = "FuelPack 2";
$SSDropItem[$SSDropCount++] = "ReloaderPack 1";
$SSDropItem[$SSDropCount++] = "GrapplePack 3";
$SSDropItem[$SSDropCount++] = "RepairPatch 10";
$SSDropItem[$SSDropCount++] = "RepairPack 2";
$SSDropItem[$SSDropCount++] = "MedicPack 3";
$SSDropItem[$SSDropCount++] = "SensorJammerPack 3";

function SupplyDrop::updatePos(%this)
{
	
	if($ProjPosition[%this] == gamebase::getposition(%this))
	{
		
		deleteobject(%this);
	}
	else
	{
	$ProjPosition[%this] = gamebase::getposition(%this);
	schedule("SupplyDrop::updatePos(" @ %this @ ");",0.1,%this);
	}
}

function DropSpecSupply(%pos)
{
%proj = Projectile::spawnProjectile("SupplyDrop", "0 0 0 0 0 0 0 0 0 " @ %pos, 2048, "0 0 0");
$SpecialSupply[%proj] = true;
}
function SpecSupplyDropDeploy(%pos)
{
	//%pos = GameBase::getPosition(%this);
	%X = getword(%pos, 0);
	%Y = getword(%pos, 1);
	%Z = getword(%pos, 2);
	
	%newpos = vector::add(%pos, "0 0 -0.5");
	%obj = newObject("CargoCrate","StaticShape","CargoCrate",true);
	addToSet("MissionCleanup", %obj);
	GameBase::setPosition(%obj, %newpos);
	if(GameBase::getlosinfo(%obj, 100, -$pi/2@" 0 0"))
	{
	
		GameBase::setPosition(%obj, $LOS::Position);
		GameBase::setRotation(%obj, vector::getRotation($LOS::Normal));
		if(getobjecttype($LOS::Object) == "Player")
		{
			GameBase::applyDamage($LOS::Object,$CrushDamageType, 100.0,vector::add(GameBase::getPosition($LOS::Object),"0 0 3"),"0 0 0","0 0 0",2048);
			if(GameBase::getlosinfo(%obj, 100, -$pi/2@" 0 0"))
			{
				GameBase::setPosition(%obj, $LOS::Position);
				GameBase::setRotation(%obj, vector::getRotation($LOS::Normal));
			}
		}
	}
	schedule("Item::Pop(" @ %obj @ ");", 120, %obj);	
	%box = %obj;
	for(%i=0;%i<$SSDropCount;%i++)
	{
		for(%j = 0; %j < getword($SSDropItem[%i], 1); %j++)
		{
		//%newpos = floor(getRandom() * 50) - floor(getRandom() * 50) +%X @ " " @ floor(getRandom() * 50) - floor(getRandom() * 50) +%Y @ " " @ %Z+10;
		%newpos = vector::add(gamebase::getposition(%box), "0 0 2");
		%obj = newObject("","Item",getword($SSDropItem[%i], 0),1,true);
		addToSet("MissionCleanup", %obj);
		GameBase::setPosition(%obj, %newpos);
		item::setvelocity(%obj, getRandom() * 25 - getRandom() * 25@" "@getRandom() * 25 - getRandom() * 25@" 10");
		if(%i < 5)
			%obj.autofill = true;
	
		schedule("Item::Pop(" @ %obj @ ");", 120, %obj);	
		}
		
	}
}

function doairdoor()
{
schedule("OpenAirplaneDoor("@nametoid("MissionGroup\\AirCraft\\AirplaneDoor\\Door\\Door")@", 0);", 0);
}